/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.parser.core.delimiter;

import icyllis.flexmark.ast.Text;
import icyllis.flexmark.parser.core.delimiter.Delimiter;
import icyllis.flexmark.util.sequence.BasedSequence;

public class Bracket {
    private final Text node;
    private final int index;
    private final boolean image;
    private final Bracket previous;
    private final Delimiter previousDelimiter;
    private boolean allowed = true;
    private boolean bracketAfter = false;

    public boolean isAllowed() {
        return this.allowed;
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    public boolean isBracketAfter() {
        return this.bracketAfter;
    }

    public void setBracketAfter(boolean bracketAfter) {
        this.bracketAfter = bracketAfter;
    }

    public Bracket getPrevious() {
        return this.previous;
    }

    public boolean isImage() {
        return this.image;
    }

    public Delimiter getPreviousDelimiter() {
        return this.previousDelimiter;
    }

    public int getStartIndex() {
        return this.index;
    }

    public int getEndIndex() {
        return this.image ? this.index + 2 : this.index + 1;
    }

    public Text getNode() {
        return this.node;
    }

    public static Bracket link(BasedSequence input, Text node, int index, Bracket previous, Delimiter previousDelimiter) {
        return new Bracket(input, node, index, previous, previousDelimiter, false);
    }

    public static Bracket image(BasedSequence input, Text node, int index, Bracket previous, Delimiter previousDelimiter) {
        return new Bracket(input, node, index, previous, previousDelimiter, true);
    }

    private Bracket(BasedSequence input, Text node, int index, Bracket previous, Delimiter previousDelimiter, boolean image) {
        this.node = node;
        this.index = index;
        this.image = image;
        this.previous = previous;
        this.previousDelimiter = previousDelimiter;
    }

    public boolean isStraddling(BasedSequence nodeChars) {
        int innerOffset;
        Delimiter inner;
        int startOffset = nodeChars.getStartOffset();
        int endOffset = nodeChars.getEndOffset();
        Delimiter delimiter = inner = this.previousDelimiter == null ? null : this.previousDelimiter.getNext();
        while (inner != null && (innerOffset = inner.getEndIndex()) < endOffset) {
            if (innerOffset >= startOffset && !inner.isMatched()) {
                return true;
            }
            inner = inner.getNext();
        }
        return false;
    }
}

